/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_2444;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.data.recipe.IRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;

public interface IMaterialRecipeHelper
extends IRecipeHelper {
    default public void materialRecipe(Consumer<class_2444> consumer, MaterialVariantId material, class_1856 input, int value, int needed, String saveName) {
        this.materialRecipe(consumer, material, input, value, needed, null, saveName);
    }

    default public void materialRecipe(Consumer<class_2444> consumer, MaterialVariantId material, class_1856 input, int value, int needed, @Nullable ItemOutput leftover, String saveName) {
        MaterialRecipeBuilder builder = MaterialRecipeBuilder.materialRecipe(material).setIngredient(input).setValue(value).setNeeded(needed);
        if (leftover != null) {
            builder.setLeftover(leftover);
        }
        builder.save(consumer, this.modResource(saveName));
    }

    default public void metalMaterialRecipe(Consumer<class_2444> consumer, MaterialVariantId material, String folder, String name, boolean optional) {
        Consumer<class_2444> wrapped = optional ? this.withCondition(consumer, this.tagCondition(name + "_ingots")) : consumer;
        String matName = material.getLocation('/').method_12832();
        class_6862<class_1792> ingotTag = this.getItemTag("c", name + "_ingots");
        this.materialRecipe(wrapped, material, class_1856.method_8106(ingotTag), 1, 1, folder + matName + "/ingot");
        wrapped = optional ? this.withCondition(consumer, this.tagCondition(name + "_nuggets")) : consumer;
        this.materialRecipe(wrapped, material, class_1856.method_8106(this.getItemTag("c", name + "_nuggets")), 1, 9, folder + matName + "/nugget");
        wrapped = optional ? this.withCondition(consumer, this.tagCondition(name + "_blocks")) : consumer;
        this.materialRecipe(wrapped, material, class_1856.method_8106(this.getItemTag("c", name + "_blocks")), 9, 1, ItemOutput.fromTag(ingotTag, 1), folder + matName + "/block");
    }

    default public void materialMelting(Consumer<class_2444> consumer, MaterialVariantId material, class_3611 fluid, long fluidAmount, String folder) {
        MaterialMeltingRecipeBuilder.material(material, new FluidStack(fluid, fluidAmount)).save(consumer, this.modResource(folder + "melting/" + material.getLocation('_').method_12832()));
    }

    default public void materialMeltingCasting(Consumer<class_2444> consumer, MaterialVariantId material, FluidObject<?> fluid, boolean forgeTag, long fluidAmount, String folder) {
        MaterialFluidRecipeBuilder.material(material).setFluid(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag(), fluidAmount).setTemperature(FluidVariantAttributes.getTemperature((FluidVariant)FluidVariant.of(fluid.get())) - 300).save(consumer, this.modResource(folder + "casting/" + material.getLocation('_').method_12832()));
        this.materialMelting(consumer, material, (class_3611)fluid.get(), fluidAmount, folder);
    }

    default public void materialMeltingCasting(Consumer<class_2444> consumer, MaterialVariantId material, FluidObject<?> fluid, boolean forgeTag, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, forgeTag, 9000L, folder);
    }

    default public void compatMeltingCasting(Consumer<class_2444> consumer, MaterialId material, FluidObject<?> fluid, String folder) {
        this.materialMeltingCasting(this.withCondition(consumer, this.tagCondition(material.method_12832() + "_ingots")), (MaterialVariantId)material, fluid, true, folder);
    }

    default public void materialMeltingCasting(Consumer<class_2444> consumer, MaterialVariantId material, FluidObject<?> fluid, long fluidAmount, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, false, fluidAmount, folder);
    }

    default public void materialMeltingCasting(Consumer<class_2444> consumer, MaterialVariantId material, FluidObject<?> fluid, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, 9000L, folder);
    }

    default public void materialMeltingComposite(Consumer<class_2444> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, boolean forgeTag, long amount, String folder) {
        this.materialMelting(consumer, output, (class_3611)fluid.get(), amount, folder);
        this.materialComposite(consumer, input, output, fluid, forgeTag, amount, folder);
    }

    default public void materialComposite(Consumer<class_2444> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, boolean forgeTag, long amount, String folder, String name) {
        MaterialFluidRecipeBuilder.material(output).setInputId(input).setFluid(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag(), amount).setTemperature(FluidVariantAttributes.getTemperature((FluidVariant)FluidVariant.of(fluid.get())) - 300).save(consumer, this.modResource(folder + "composite/" + name));
    }

    default public void materialComposite(Consumer<class_2444> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, boolean forgeTag, long amount, String folder) {
        this.materialComposite(consumer, input, output, fluid, forgeTag, amount, folder, output.getLocation('_').method_12832());
    }
}

